CREATE OR REPLACE PACKAGE TPX_EMPLOYEE AS
/*==============================================================================
    Object Name  : TPX_EMPLOYEE
    Object Type  : PACKAGE
    Description  : 직원 관리 패키지
==============================================================================*/

    -- 직원 등록
    PROCEDURE INS_EMPLOYEE (
        iEmpKey     IN VARCHAR2,
        iEmpName    IN VARCHAR2,
        iDeptCode   IN VARCHAR2,
        iRegularYn  IN CHAR
    );
    
    -- 직원 존재 여부 확인
    FUNCTION EXISTS_EMPLOYEE (
        iEmpKey IN VARCHAR2
    ) RETURN BOOLEAN;

    -- 정규직 여부 확인
    FUNCTION IS_REGULAR_EMPLOYEE (
        iEmpKey IN VARCHAR2
    ) RETURN CHAR;


END TPX_EMPLOYEE;
/

CREATE OR REPLACE PACKAGE BODY TPX_EMPLOYEE AS
/*==============================================================================
    Object Name  : TPX_EMPLOYEE
    Object Type  : PACKAGE
    Description  : 직원 관리 패키지
==============================================================================*/

    -- 직원 존재 여부 확인
    FUNCTION EXISTS_EMPLOYEE (
        iEmpKey IN VARCHAR2
    ) RETURN BOOLEAN IS
        vCount NUMBER;
    BEGIN
        BEGIN
            SELECT COUNT(*)
            INTO vCount
            FROM TPJ_EMPLOYEE
            WHERE EMP_KEY = iEmpKey;
            
            RETURN vCount > 0;
        EXCEPTION
            WHEN OTHERS THEN
                RAISE_APPLICATION_ERROR(-20000, 'Error in EXISTS_EMPLOYEE: ' || SQLERRM);
        END;
    END EXISTS_EMPLOYEE;


    -- 정규직 여부 확인
    FUNCTION IS_REGULAR_EMPLOYEE (
        iEmpKey IN VARCHAR2
    ) RETURN CHAR IS
        vRegularYn CHAR(1);
    BEGIN
        BEGIN
            SELECT REGULAR_YN
            INTO vRegularYn
            FROM TPJ_EMPLOYEE
            WHERE EMP_KEY = iEmpKey;
            
            RETURN vRegularYn;
        EXCEPTION
            WHEN OTHERS THEN
                RAISE_APPLICATION_ERROR(-20000, 'Error in IS_REGULAR_EMPLOYEE: ' || SQLERRM);
        END;
    END IS_REGULAR_EMPLOYEE;


    -- 직원 등록
    PROCEDURE INS_EMPLOYEE (
        iEmpKey     IN VARCHAR2,
        iEmpName    IN VARCHAR2,
        iDeptCode   IN VARCHAR2,
        iRegularYn  IN CHAR
    ) IS
        vExists BOOLEAN;
    BEGIN
        BEGIN
            -- 이미 존재하는 직원인지 확인
            vExists := EXISTS_EMPLOYEE(iEmpKey);
            IF vExists THEN
                RAISE_APPLICATION_ERROR(-20000, '이미 존재하는 직원입니다: ' || iEmpKey);
            END IF;
            
            INSERT INTO TPJ_EMPLOYEE (
                EMP_KEY, EMP_NAME, DEPT_CODE, REGULAR_YN
            ) VALUES (
                iEmpKey, iEmpName, iDeptCode, iRegularYn
            );
        EXCEPTION
            WHEN OTHERS THEN
                RAISE_APPLICATION_ERROR(-20000, 'Error in INS_EMPLOYEE: ' || SQLERRM);
        END;
    END INS_EMPLOYEE;

END TPX_EMPLOYEE;
/