CREATE OR REPLACE PROCEDURE TPX_UPDATE_SALARY (
    pEmpKey IN VARCHAR2,
    pEmpName IN VARCHAR2,
    pDeptCode IN VARCHAR2,
    pBaseAmount IN NUMBER,
    pPayDate IN DATE,
    pRegularYn IN CHAR
) IS
    vExists BOOLEAN;
    vSalaryExists BOOLEAN;
BEGIN
    BEGIN
		    -- 직원이 존재하는지 확인
        vExists := TPX_EMPLOYEE.EXISTS_EMPLOYEE(pEmpKey);
        IF NOT vExists THEN
            TPX_EMPLOYEE.INS_EMPLOYEE(pEmpKey, pEmpName, pDeptCode, pRegularYn);
        END IF;
				-- 해당 직원에 대한 급여가 존재하는지 확인
        vSalaryExists := TPX_SALARY.EXISTS_SALARY(pEmpKey, pPayDate);
        IF NOT vSalaryExists THEN
            TPX_SALARY.INS_SALARY(pEmpKey, pPayDate, pBaseAmount);
        END IF;
				
				-- 결근에 따른 급여 업데이트
        TPX_SALARY.UPD_SALARY_BY_ABSENT(pEmpKey, pPayDate);

    EXCEPTION
        WHEN OTHERS THEN
            RAISE_APPLICATION_ERROR(-20000, 'Error in TPX_UPDATE_SALARY: ' || SQLERRM);
    END;
END TPX_UPDATE_SALARY;
/